// $Id: CRepeatingButton.cpp,v 1.5 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CRepeatingButton.hpp"
using Exponent::GUI::Controls::CRepeatingButton;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CRepeatingButton, CRolloverButton);

//	===========================================================================
CRepeatingButton::CRepeatingButton(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener) 
				: CRolloverButton(root, uniqueId, area, listener)
				, m_timeInMilliseconds(100)
{
	EXPONENT_CLASS_CONSTRUCTION(CRepeatingButton);

	this->controlIsMouseEnabled();
	m_rootControl->getParentWindow()->addTimedObject(this);
}

//	===========================================================================
CRepeatingButton::~CRepeatingButton()
{
	EXPONENT_CLASS_DESTRUCTION(CRepeatingButton);
	m_rootControl->getParentWindow()->removeTimedObject(this);
}

//	===========================================================================
void CRepeatingButton::handleLeftButtonDown(CMouseEvent &event)
{
	CRolloverButton::handleLeftButtonDown(event);
	if (m_state == CRolloverButton::e_mouseDown)
	{
		m_rootControl->getParentWindow()->startTimer(this->getUniqueId(), m_timeInMilliseconds);
	}
}

//	===========================================================================
void CRepeatingButton::handleLeftButtonUp(CMouseEvent &event)
{
	CRolloverButton::handleLeftButtonUp(event);
	m_rootControl->getParentWindow()->stopTimer(this->getUniqueId());
}

//	===========================================================================
void CRepeatingButton::handleMouseMovement(CMouseEvent &event)
{
	CRolloverButton::handleMouseMovement(event);
	if (m_state != CRolloverButton::e_mouseDown)
	{
		m_rootControl->getParentWindow()->stopTimer(this->getUniqueId());
	}
}

//	===========================================================================
void CRepeatingButton::setRepeatTime(const long timeInMilliseconds)
{
	m_timeInMilliseconds = timeInMilliseconds;
}

//	===========================================================================
void CRepeatingButton::timerExpired()
{
	if (m_actionListener)
	{
		m_actionListener->handleActionEvent(CActionEvent(this));
	}
}